/*
 * Decompiled with CFR 0.152.
 */
package libsidplay.components.cart.supported;

import java.io.DataInputStream;
import java.io.IOException;
import libsidplay.components.cart.Cartridge;
import libsidplay.components.pla.Bank;
import libsidplay.components.pla.PLA;

public class MikroAss
extends Cartridge {
    protected final byte[] romL;
    private final Bank io1Bank = new Bank(){

        @Override
        public byte read(int address) {
            return MikroAss.this.romL[address & 0x1FFF];
        }

        @Override
        public void write(int address, byte value) {
        }
    };
    private final Bank io2Bank = new Bank(){

        @Override
        public byte read(int address) {
            return MikroAss.this.romL[address & 0x1FFF];
        }

        @Override
        public void write(int address, byte value) {
        }
    };

    public MikroAss(DataInputStream dis, PLA pla) throws IOException {
        super(pla);
        byte[] chipHeader = new byte[16];
        dis.readFully(chipHeader);
        int bankLen = (chipHeader[14] & 0xFF) << 8;
        this.romL = new byte[bankLen];
        dis.readFully(this.romL);
    }

    @Override
    public Bank getIO1() {
        return this.io1Bank;
    }

    @Override
    public Bank getIO2() {
        return this.io2Bank;
    }

    @Override
    public void reset() {
        super.reset();
        this.pla.setGameExrom(true, false);
    }
}

